<?php

require '../fpdf1/fpdf/fpdf.php';
require '../fpdf1/conexion/Conexion.php'; //puede que no lo necesiten
class PDF extends FPDF {

// Cabecera de página

	function Header() {


		$this->SetFont('Times', 'B', 18);
		$this->setXY(20, 48);		
		$this->Cell(155, 8, 'PANEL DE CONTROL / MT', 0, 1, 'C', 0);
		
		$this->SetFont('Times', 'B', 10);
		$this->Image('../img/icons/enc.jpg', 160, 10, 30); //imagen(archivo, png/jpg || x,y,tamaño)

		$this->SetFont('Times', 'B', 10	);
		$this->setXY(160, 20);
		$this->Cell(10, 8, utf8_decode('Empresa de Navegación CARIBE'), 0, 1, 'C', 0);

		$this->SetFont('Times', 'B', 7	);
		$this->setXY(162, 25);
		$this->Cell(10, 8, utf8_decode('Carretera del Naval # 9, Casablanca, Regla'), 0, 1, 'C', 0);
		$this->setXY(169, 30);
		$this->Cell(10, 8, utf8_decode('Teléfono: 77671563 / 77671548'), 0, 1, 'C', 0);
		$this->setXY(164, 35);
		$this->Cell(10, 8, utf8_decode('Correo: directorenc@navcar.transnet.cu'), 0, 1, 'C', 0);


		
		$this->SetFont('Arial', 'I', 8); //tipo fuente, cursiva, tamañoTexto
		$hoy = date('d/m/Y');
		$this->Cell(50, 50,'La Habana' . ' ' .utf8_decode($hoy), 0, 0, 'C'); // pie de pagina(fecha de pagina)

		$this->Image('img/logo.png',0,0,50); //imagen(archivo, png/jpg || x,y,tamaño)
		
		$this->Ln(2);

		$this->SetFont('Times', 'B', 12);
		$this->setXY(20, 70);		
		$this->Cell(80, 8, 'Listado de Remolcadores NO OPERATIVOS', 0, 1, 'C', 0);

		
		
		
		/* $this->Image('img/shinheky.png', 150, 10, 35); //imagen(archivo, png/jpg || x,y,tamaño) */
		$this->Ln(2);


		
		
	}

// Pie de página

	function Footer() {
		// Posición: a 1,5 cm del final
		

		$this->SetFont('Arial', 'B', 10);



		$this->setXY(10, 275);
		$this->SetY(-15);
		$this->Cell(25, 10, utf8_decode('Página ') . $this->PageNo() . '/{nb}', 0, 0, 'C');

		// Número de página
		$this->setXY(140, 275);
		$this->SetY(-15);
		$this->Cell(330, 10, utf8_decode('Todos los derechos reservados ®'), 0, 0, 'C', 0);


		// Número de página
		$this->setXY(140, 275);
		$this->SetY(-15);
		$this->Cell(175, 10, utf8_decode('Management Técnico / 2023'), 0, 0, 'C', 0);

		
	}

// --------------------METODO PARA ADAPTAR LAS CELDAS------------------------------
	var $widths;
	var $aligns;

	function SetWidths($w) {
		//Set the array of column widths
		$this->widths = $w;
	}

	function SetAligns($a) {
		//Set the array of column alignments
		$this->aligns = $a;
	}

	function Row($data, $setX) //yo modifique el script a  mi conveniencia :D
	{
		//Calculate the height of the row
		$nb = 0;
		for ($i = 0; $i < count($data); $i++) {
			$nb = max($nb, $this->NbLines($this->widths[$i], $data[$i]));
		}

		$h = 8 * $nb;
		//Issue a page break first if needed
		$this->CheckPageBreak($h, $setX);
		//Draw the cells of the row
		for ($i = 0; $i < count($data); $i++) {
			$w = $this->widths[$i];
			$a = isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
			//Save the current position
			$x = $this->GetX();
			$y = $this->GetY();
			//Draw the border
			$this->Rect($x, $y, $w, $h, 'DF');
			//Print the text
			$this->MultiCell($w, 8, $data[$i], 0, $a);
			//Put the position to the right of the cell
			$this->SetXY($x + $w, $y);
		}
		//Go to the next line
		$this->Ln($h);
	}

	function CheckPageBreak($h, $setX) {
		//If the height h would cause an overflow, add a new page immediately
		if ($this->GetY() + $h > $this->PageBreakTrigger) {
			$this->AddPage($this->CurOrientation);
			$this->SetX($setX);

			//volvemos a definir el  encabezado cuando se crea una nueva pagina
			$this->SetFont('Helvetica', 'B', 10);
			$this->Cell(10, 8, 'N', 1, 0, 'C', 0);
			$this->Cell(25, 8, 'Imo', 1, 0, 'C', 0);
			$this->Cell(40, 8, 'Buque', 1, 0, 'C', 0);
			$this->Cell(110, 8, 'Observaciones', 1, 1, 'C', 0);
			$this->SetFont('Arial', '', 10);

		}

		if ($setX == 100) {
			$this->SetX(100);
		} else {
			$this->SetX($setX);
		}

	}

	function NbLines($w, $txt) {
		//Computes the number of lines a MultiCell of width w will take
		$cw = &$this->CurrentFont['cw'];
		if ($w == 0) {
			$w = $this->w - $this->rMargin - $this->x;
		}

		$wmax = ($w - 2 * $this->cMargin) * 1000 / $this->FontSize;
		$s = str_replace("\r", '', $txt);
		$nb = strlen($s);
		if ($nb > 0 and $s[$nb - 1] == "\n") {
			$nb--;
		}

		$sep = -1;
		$i = 0;
		$j = 0;
		$l = 0;
		$nl = 1;
		while ($i < $nb) {
			$c = $s[$i];
			if ($c == "\n") {
				$i++;
				$sep = -1;
				$j = $i;
				$l = 0;
				$nl++;
				continue;
			}
			if ($c == ' ') {
				$sep = $i;
			}

			$l += $cw[$c];
			if ($l > $wmax) {
				if ($sep == -1) {
					if ($i == $j) {
						$i++;
					}

				} else {
					$i = $sep + 1;
				}

				$sep = -1;
				$j = $i;
				$l = 0;
				$nl++;
			} else {
				$i++;
			}

		}
		return $nl;
	}
// -----------------------------------TERMINA---------------------------------
}

//------------------OBTENES LOS DATOS DE LA BASE DE DATOS-------------------------
$data = new Conexion();
$conexion = $data->conect();
$strquery = "SELECT * FROM barcos_enc where disponibildad_tec='2' AND tipo_barco='Remolcador'";
$result = $conexion->prepare($strquery);
$result->execute();
$data = $result->fetchall(PDO::FETCH_ASSOC);

/* IMPORTANTE: si estan usando MVC o algún CORE de php les recomiendo hacer uso del metodo
que se llama *select_all* ya que es el que haria uso del *fetchall* tal y como ven en la linea 161
ya que es el que devuelve un array de todos los registros de la base de datos
si hacen uso de el metodo *select* hara uso de fetch y este solo selecciona una linea*/

//--------------TERMINA BASE DE DATOS-----------------------------------------------

// Creación del objeto de la clase heredada
$pdf = new PDF(); //hacemos una instancia de la clase
$pdf->AliasNbPages();
$pdf->AddPage(); //añade l apagina / en blanco
$pdf->SetMargins(10, 10, 10); //MARGENES
$pdf->SetAutoPageBreak(true, 20); //salto de pagina automatico

// -----------ENCABEZADO------------------


$pdf->SetX(15);
$pdf->SetFont('Helvetica', 'B', 10);
$pdf->Cell(10, 8, '#', 1, 0, 'C', 0);
$pdf->Cell(25, 8, 'Imo', 1, 0, 'C', 0);
$pdf->Cell(40, 8, 'Buque', 1, 0, 'C', 0);
$pdf->Cell(110, 8, 'Observaciones', 1, 1, 'C', 0);




// -------TERMINA----ENCABEZADO------------------

$pdf->SetFillColor(233, 229, 235); //color de fondo rgb
$pdf->SetDrawColor(61, 61, 61); //color de linea  rgb

$pdf->SetFont('Arial', '', 10);

//El ancho de las celdas
$pdf->SetWidths(array(10, 25, 40, 110)); //???

// esto no lo mencione en el video pero también pueden poner la alineación de cada COLUMNA!!!
$pdf->SetAligns(array('C','C','C','L'));

for ($i = 0; $i < count($data); $i++) {

	$pdf->Row(array($i + 1, $data[$i]['IMO'], utf8_decode($data[$i]['nombre_barco']),ucwords(strtolower(utf8_decode( $data[$i]['ob_disponibilidad'])))), 15);
}

// cell(ancho, largo, contenido,borde?, salto de linea?)

$pdf->Output();
?>